### **实验名称**

分类算法的应用案例：人才流失分析

### **实验目的**

1.了解分类算法理论基础

2.编程实现SVM算法

3.编程实现决策树算法

4.编程实现随机森林算法

5.编程实现AdaBoost算法

6.能进行模型评估，包括使用混淆矩阵、准确率、精确率、召回率等评价指标

7.能比较不同分类算法的性能

### **实验背景**

在人力资源管理领域中，分析各项员工工作相关的数据和指标，可以揭示员工流失的趋势和原因、薪酬公平性、员工满意度以及职业发展路径等关键指标。这些见解对于优化人才招聘、留存策略、绩效评估体系和员工发展计划至关重要。 本项目主要针对员工流失情况来进行分析，并且建立了分类模型来预测员工是否存在离职的可能，有助于帮助公司提前与该员工沟通，并且及时作出战略性调整。

### **实验原理**

#### 1 支持向量机(SVM)的基本原理

**支持向量机（Support Vector Machine, SVM）**是一种监督学习算法，广泛用于分类和回归分析。SVM通过找到一个最佳的决策边界，将不同类别的样本进行有效的分类。它在处理高维空间、非线性数据时表现出色，具有较强的泛化能力。

![01-svm.png](./pic/01-svm.png)

（1）**决策边界**：

*   SVM的核心思想是找到一个能够最大化类别间隔（即“margin”）的决策边界。对于线性可分的情况，这个边界是一个超平面，在二维空间中是直线，在三维空间中是平面，在更高维度空间中是超平面。
    

（2）**最大化间隔**：

*   SVM选择离决策边界最近的点作为支持向量，这些支持向量决定了决策边界的位置。SVM通过最大化支持向量与决策边界之间的最小距离来构建最优的分类超平面。
    

（3）**线性可分与非线性可分**：

*   对于线性可分的数据，SVM直接找到一个线性超平面进行分类。
    
*   对于非线性可分的数据，SVM使用**核函数（Kernel Function）将数据映射到更高维空间，使得在高维空间中数据线性可分。常见的核函数包括多项式核（Polynomial Kernel）**、**高斯核（RBF Kernel）**等。
    
    ![01-svm2.png](./pic/01-svm2.png)
    

（4）**软间隔（Soft Margin）**：

*   在实际应用中，数据通常不是完全线性可分的。SVM引入了软间隔的概念，允许一些数据点位于决策边界的错误一侧，通过引入一个松弛变量来平衡分类的准确性和间隔的大小。此时的SVM模型通过一个参数来控制间隔的大小和误分类的惩罚程度。
    

#### 2 决策树的基本原理

**决策树（Decision Tree）**是一种监督学习算法，广泛用于分类和回归任务。它通过将数据集递归地分割成更小的子集，形成一个类似树结构的模型，用于预测目标变量的值。决策树因其易于理解和解释的特点，被广泛应用于各种机器学习问题。

![02-决策树-1.png](./pic/02-决策树-1.png)                    ![02-决策树2.png](./pic/02-决策树2.png)

(1)**树的结构**：

*   **根节点（Root Node）**：表示整个数据集，是树的起始点。
    
*   **内部节点（Internal Nodes）**：表示根据某个特征进行的决策或条件判断。
    
*   **叶节点（Leaf Nodes）**：表示最终的分类结果或回归预测值。
    

(2)**划分依据**：

*   决策树通过递归地选择特征并根据特征的取值将数据集分割成子集，每次选择的特征旨在最大化子集间的纯度差异。不同算法使用不同的指标来衡量分割效果，如**信息增益（Information Gain）**、**基尼系数（Gini Index）**或**方差减少（Variance Reduction）**等。
    

(3)**递归划分**：

*   决策树从根节点开始，对每个节点选择最优特征进行划分，直到满足停止条件（如达到最大深度、节点的纯度足够高、或没有更多特征可用）为止。
    

#### 3 随机森林的基本原理

**随机森林（Random Forest）是一种集成学习方法，通过结合多个决策树来提高模型的准确性、鲁棒性和泛化能力。它是基于Bagging**（Bootstrap Aggregating）的思想，通过对数据进行有放回的随机采样，生成多个不同的子数据集，每个子数据集训练一个决策树模型。最终，随机森林通过对这些决策树的预测结果进行平均（回归任务）或投票（分类任务）来得到最终的预测结果。

![03随机森林.png](./pic/03随机森林.png)

(1)**Bagging**：

*   **随机采样**：对于一个有 NNN 个样本的数据集，随机森林通过有放回的方式随机抽取 NNN 个样本来创建子数据集，这意味着有的样本可能会被多次选中，而有的样本可能不会被选中。
    
*   **决策树训练**：每个子数据集训练一个决策树模型。这些树是独立的，并且由于数据集的随机性，它们各自可能会有所不同。
    

(2)**随机特征选择**：

*   在每个决策树的构建过程中，随机森林算法还会在每次分裂节点时随机选择一个特征子集（而不是所有特征）来决定最佳分裂。这一过程增加了模型的多样性，降低了模型的相关性，从而减少了过拟合的风险。
    

(3)**预测集成**：

*   对于分类任务：随机森林中的所有决策树对每个输入样本进行分类，最终选择最多数的类别作为最终预测结果（**多数投票**）。
    
*   对于回归任务：随机森林中的所有决策树对每个输入样本进行预测，最终取这些预测值的平均值作为最终预测结果。
    

#### 4 AdaBoost的基本原理

**AdaBoost**（Adaptive Boosting）是提升（Boosting）算法的一种，用于提高分类和回归模型的准确性。AdaBoost的基本思想是通过组合多个弱学习器（通常是简单的模型，如决策树桩），形成一个强学习器。每个弱学习器依次训练，并根据前一个学习器的错误进行调整，使后续学习器更关注那些被错误分类的样本。

![04AdaBoost.png](./pic/04AdaBoost.png)

(1)**初始化样本权重**：

*   在开始时，所有训练样本的权重相等，每个样本的权重为 1N\\frac{1}{N}N1，其中 NNN 是样本总数。AdaBoost通过调整这些权重，来使得模型更专注于难以正确分类的样本。
    

(2)**迭代训练弱学习器**：

*   **弱学习器**：通常使用简单的模型（如单层决策树，称为决策树桩）作为弱学习器。AdaBoost会在每一轮迭代中训练一个新的弱学习器。
    
*   **加权错误率**：在每一轮迭代中，计算弱学习器的加权错误率（错误率考虑了样本的权重）。加权错误率是根据当前模型对样本的错误分类情况来计算的，错误分类的样本权重较大。
    
*   **调整弱学习器的权重**：根据加权错误率，计算该弱学习器的权重（称为 α\\alphaα），这个权重表示该学习器在最终预测中的重要性。错误率越低的学习器权重越大，表示其分类效果越好。
    
*   **更新样本权重**：根据学习器的表现，调整样本的权重。错误分类的样本权重会增加，正确分类的样本权重会减小。这样，下一轮的学习器将更关注那些被前一轮错误分类的样本。
    

(3)**组合弱学习器**：

*   最终模型是各个弱学习器的加权组合。对于分类任务，AdaBoost通过加权投票来决定最终类别；对于回归任务，AdaBoost通过加权平均来做出最终预测。
    

### **实验环境**

Ubuntu 18.04

scikit-learn 1.4.1

python 3.9

jupyter notebook 1.0.0

pandas 2.0.3

### 建议课时

4课时

### 实验步骤

#### 1.下载数据

双击打开桌面的“terminal”后，在命令行中输入如下命令

```markup
cd ~
wget http://10.90.3.2/HUP/DataMining/2024/06/HR_Analytics.csv
```

#### 2.开启 jupyter notebook

在命令行中输入如下命令

```markup
jupyter notebook
```

浏览器中打开 Jupyter，点击右上角上的“New”按钮，选择“python3”创建文件。

![1721522453348.png](./pic/1721522453348.png)

#### 3.查看数据

**数据说明**

| 字段 | 说明 |
| --- | --- |
| EmpID | 唯一的员工ID |
| Age | 年龄 |
| AgeGroup | 年龄组 |
| Attrition | 是否离职 |
| BusinessTravel | 出差：很少、频繁、不出差 |
| DailyRate | 日薪 |
| Department | 任职部门：研发部门、销售部门、人力资源部门 |
| DistanceFromHome | 通勤距离 |
| Education | 教育等级 |
| EducationField | 专业领域：生命科学、医学、市场营销、技术、其他 |
| EnvironmentSatisfaction | 工作环境满意度 |
| Gender | 性别 |
| HourlyRate | 时薪 |
| JobInvolvement | 工作参与度 |
| JobLevel | 工作级别 |
| JobRole | 工作角色 |
| JobSatisfaction | 工作满意度 |
| MaritalStatus | 婚姻状况 |
| MonthlyIncome | 月收入 |
| SalarySlab | 工资单 |
| MonthlyRate | 月薪 |
| NumCompaniesWorked | 工作过的公司数量 |
| PercentSalaryHike | 加薪百分比 |
| PerformanceRating | 绩效评级 |
| RelationshipSatisfaction | 关系满意度 |
| StandardHours | 标准工时 |
| StockOptionLevel | 股票期权级别 |
| TotalWorkingYears | 总工作年数 |
| TrainingTimesLastYear | 去年培训时间 |
| WorkLifeBalance | 工作生活平衡评价 |
| YearsAtCompany | 在公司工作年数 |
| YearsInCurrentRole | 担任现职年数 |
| YearsSinceLastPromotion | 上次晋升后的年数 |
| YearsWithCurrManager | 与现任经理共事年数 |

```python
# 导入需要的库
import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
from sklearn.preprocessing import OneHotEncoder
from sklearn.model_selection import train_test_split
from sklearn.utils import resample
from sklearn.metrics import classification_report
# 读取数据
df = pd.read_csv("HR_Analytics.csv")
df.head()
```

![05实验步骤-01.png](./pic/05实验步骤-01.png)

```python
# 查看数据维度
df.shape
# 查看数据信息
df.info()
```

![image_course_1657_user_3961_assignment_20194_1724305189930.png](./pic/image_course_1657_user_3961_assignment_20194_1724305189930.png)

**可以看到最后一个字段YearsWithCurrManager 有缺失**

```python
# 查看重复值
df.duplicated().sum()
```

7

#### 4.数据处理

```python
# 删除重复值
df.drop_duplicates(inplace=True)
# 删除缺失值
df.dropna(subset=['YearsWithCurrManager'],inplace=True)
# 检查StandardHours列是否为常数
df['StandardHours'].nunique()
```

**StandardHours列所有值都是一样，对分析没有用，可以删除。**

```python
# 删除 'StandardHours' 字段
df.drop('StandardHours', axis=1,inplace=True)
# 查看每个对象类型字段的唯一值数量
df.select_dtypes(include=['object']).nunique()
```

![image_course_1657_user_3961_assignment_20194_1724305109594.png](./pic/image_course_1657_user_3961_assignment_20194_1724305109594.png)

```python
# 转换字段为'category'数据类型
category_columns = ['AgeGroup', 'Attrition', 'BusinessTravel', 'Department',
                    'EducationField', 'Gender', 'JobRole', 'MaritalStatus', 'SalarySlab']

df[category_columns] = df[category_columns].astype('category')
# 转换EmpID为字符串类型
df['EmpID'] = df['EmpID'].astype(str)
# 确认转换后的数据类型
df.dtypes
```

![image_course_1657_user_3961_assignment_20194_1724305082550.png](./pic/image_course_1657_user_3961_assignment_20194_1724305082550.png)

```python
# 查看 BusinessTravel的值有哪些
df["BusinessTravel"].value_counts()
```

![image_course_1657_user_3961_assignment_20194_1724305009562.png](./pic/image_course_1657_user_3961_assignment_20194_1724305009562.png)

**TravelRarely和Travel\_Rarely是相同的意思”很少出差“，需要改成相同的名字**

```python
df['BusinessTravel'] = df['BusinessTravel'].replace('TravelRarely', 'Travel_Rarely') # 这是后面分析出差的时候发现需要替换一下数值
```

#### 5.离职情况分析

##### 5.1离职员工占比

```python
# 基本统计 - 离职与未离职员工的比例
attrition_counts = df['Attrition'].value_counts()
attrition_rate = attrition_counts / len(df) * 100

# 绘制离职与未离职员工的比例图
plt.figure(figsize=(10,8))
sns.barplot(x=attrition_counts.index, y=attrition_counts.values)
plt.title('Employee Attrition vs. Retention')
plt.xlabel('Attrition Status')
plt.ylabel('Number of Employees')
plt.xticks(range(2), ['No', 'Yes'])
plt.show()
```

![项目5-1.png](./pic/项目5-1.png)

##### 5.2员工个人情况

```python
# 年龄段与离职人数的关系
age_attrition = df.groupby('AgeGroup')['Attrition'].value_counts().unstack().fillna(0)

# 婚姻情况与离职率的关系
marital_status_attrition = pd.crosstab(df['MaritalStatus'], df['Attrition'])
marital_status_attrition_percent = marital_status_attrition.div(marital_status_attrition.sum(axis=1), axis=0) * 100

# 性别与离职率的关系
gender_attrition = pd.crosstab(df['Gender'], df['Attrition'])
gender_attrition_percent = gender_attrition.div(gender_attrition.sum(axis=1), axis=0) * 100

fig = plt.figure(figsize=(10,15))

# 添加前两个小图
ax1 = fig.add_subplot(3, 1, 1)
ax2 = fig.add_subplot(3, 1, 2)
# 添加第二行的大图，这个大图跨越了两列
ax3 = fig.add_subplot(3, 1, 3)

# 性别与离职率的关系
gender_attrition_percent['Yes'].plot(kind='bar', ax=ax1)
ax1.set_title('Attrition Rate by Gender')
ax1.set_xlabel('Gender')
ax1.set_ylabel('Attrition Rate (%)')
ax1.set_xticklabels(ax1.get_xticklabels(), rotation=0)
# 添加数据标签
for p in ax1.patches:
    ax1.annotate(f"{p.get_height():.1f}%", (p.get_x() + p.get_width() / 2., p.get_height()),
                       ha='center', va='center', xytext=(0, 10), textcoords='offset points')

# 婚姻情况与离职率的关系
marital_status_attrition_percent['Yes'].plot(kind='bar', ax=ax2)
ax2.set_title('Attrition Rate by Marital Status')
ax2.set_xlabel('Marital Status')
ax2.set_ylabel('Attrition Rate (%)')
ax2.set_xticklabels(ax2.get_xticklabels(), rotation=0)
# 添加数据标签
for p in ax2.patches:
    ax2.annotate(f"{p.get_height():.1f}%", (p.get_x() + p.get_width() / 2., p.get_height()),
                        ha='center', va='center', xytext=(0, 10), textcoords='offset points')
# 年龄与离职人数的关系
age_attrition.plot(kind='bar', ax=ax3)
ax3.set_title('Number of Attritions by Age')
ax3.set_xlabel('Age')
ax3.set_ylabel('Number of Attritions')
ax3.set_xticklabels(ax3.get_xticklabels(), rotation=0)
# 添加数据标签
for p in ax3.patches:
    ax3.annotate(f"{int(p.get_height())}", (p.get_x() + p.get_width() / 2., p.get_height()),
                    ha='center', va='center', xytext=(0, 10), textcoords='offset points')
plt.tight_layout()
plt.show()
```

![项目5-2-1.png](./pic/项目5-2-1.png)

![项目5-2-2.png](./pic/项目5-2-2.png)

![项目5-2-3-1.png](./pic/项目5-2-3-1.png)

**1.离职情况主要集中在18-35岁的员工群体中。**

**2.随着年龄增长，离职的人数有所下降。**

**3.男性的离职率略高于女性的离职率。 4.单身的员工离职率最高。**

##### 5.3工作方面

```python
# 出差
business_travel_attrition = pd.crosstab(df['BusinessTravel'], df['Attrition'])
business_travel_attrition_percent = business_travel_attrition.div(business_travel_attrition.sum(axis=1), axis=0) * 100

# 部门
department_attrition = pd.crosstab(df['Department'], df['Attrition'])
department_attrition_percent = department_attrition.div(department_attrition.sum(axis=1), axis=0) * 100

plt.figure(figsize=(10, 15))
# 绘制出差离职率
plt.subplot(4, 1, 1)
business_travel_attrition_percent['Yes'].plot(kind='bar', color='skyblue')
plt.title('Attrition Rate by Business Travel')
plt.xlabel('Business Travel')
plt.ylabel('Attrition Rate (%)')
for p in plt.gca().patches:
    plt.gca().annotate(f"{p.get_height():.1f}%", (p.get_x() + p.get_width() / 2., p.get_height()),
                       ha='center', va='center', xytext=(0, -10), textcoords='offset points')
plt.xticks(rotation=0)
# 绘制各部门的离职率图表
plt.subplot(4, 1, 2)
department_attrition_percent['Yes'].plot(kind='bar', color='lightgreen')
plt.title('Attrition Rate by Department')
plt.xlabel('Department')
plt.ylabel('Attrition Rate (%)')
for p in plt.gca().patches:
    plt.gca().annotate(f"{p.get_height():.1f}%", (p.get_x() + p.get_width() / 2., p.get_height()),
                       ha='center', va='center', xytext=(0, -10), textcoords='offset points')
plt.xticks(rotation=0)
# 通勤距离与离职的关系
plt.subplot(4, 1, 3)
sns.boxplot(x='Attrition', y='DistanceFromHome', data=df)
plt.title('Attrition by Distance From Home')  # 按通勤距离划分的离职情况
plt.xlabel('Attrition Status')  # 离职状态
plt.ylabel('Distance From Home')  # 通勤距离
plt.xticks(rotation=0)
# 工作角色与离职率的关系
job_role_attrition_percent = pd.crosstab(df['JobRole'], df['Attrition'], normalize='index') * 100
plt.subplot(4, 1, 4)  # 横跨第二行的三列
job_role_attrition_percent['Yes'].plot(kind='bar', color='lightblue')
plt.title('Attrition Rate by Job Role')
plt.xlabel('Job Role')
plt.ylabel('Attrition Rate (%)')
for p in plt.gca().patches:
    plt.gca().annotate(f"{p.get_height():.1f}%", (p.get_x() + p.get_width() / 2., p.get_height()),
                       ha='center', va='center', xytext=(0, -10), textcoords='offset points')
plt.xticks(rotation=30)
plt.tight_layout()
plt.show()
```

![项目5-3-1.png](./pic/项目5-3-1.png)

![项目5-3-2-1.png](./pic/项目5-3-2-1.png)

**1.经常出差的员工离职率高。**

**2.人力资源部门和销售部门的离职率比研发部门高。**

**3.离职的员工离职员工的通勤距离中位数略高于未离职员工，这表明较远的通勤距离可能与更高的离职率有关。**

**4.销售代表的离职率最高，约为39.8%。**

**5.人力资源和实验室技术员的离职率也相对较高，分别约为23.5%和24.1%。**

**6.相比之下，研究总监、 经理和制造总监的离职率较低，分别为2.6% 、5.0%和6.5%**

##### 5.4薪酬方面

```python
plt.figure(figsize=(8, 8))
# 加薪百分比与离职的关系
plt.subplot(2, 2, 1)
sns.boxplot(x='Attrition', y='PercentSalaryHike', data=df)
plt.title('Attrition by Percent Salary Hike')
plt.xlabel('Attrition')
plt.ylabel('Percent Salary Hike')

# 绩效评级与离职的关系
plt.subplot(2, 2, 2)
sns.countplot(x='PerformanceRating', hue='Attrition', data=df)
plt.title('Attrition by Performance Rating')
plt.xlabel('Performance Rating')
plt.ylabel('Count')

# 股票期权级别与离职的关系
plt.subplot(2, 2, 3)
sns.countplot(x='StockOptionLevel', hue='Attrition', data=df)
plt.title('Attrition by Stock Option Level')
plt.xlabel('Stock Option Level')
plt.ylabel('Count')

# 去年培训时间与离职的关系
plt.subplot(2, 2, 4)
sns.countplot(x='TrainingTimesLastYear', hue='Attrition', data=df)
plt.title('Attrition by Training Times Last Year')
plt.xlabel('Training Times Last Year')
plt.ylabel('Count')

plt.tight_layout()
plt.show()
```

![项目5-4-1-1.png](./pic/项目5-4-1-1.png)

**1.离职员工加薪百分比中位数明显低于未离职员工。**

**2.绩效评级只有3级和4级，离职率看起来与绩效评级的关系并不大。**

**3.股票期权级别越高，越不容易离职。**

**4.去年培训时间看起来与离职率的关系并不算大。**

##### 5.5晋升方面

```python
plt.figure(figsize=(8,8))

# 在公司工作年数与离职情况的关系
plt.subplot(2, 2, 1)
sns.boxplot(x='Attrition', y='YearsAtCompany', data=df)
plt.title('Attrition by Years at Company')
plt.xlabel('Attrition')
plt.ylabel('Years at Company')

# 担任现职年数与离职情况的关系
plt.subplot(2, 2, 2)
sns.boxplot(x='Attrition', y='YearsInCurrentRole', data=df)
plt.title('Attrition by Years in Current Role')
plt.xlabel('Attrition')
plt.ylabel('Years in Current Role')

# 上次晋升后的年数与离职情况的关系
plt.subplot(2, 2, 3)
sns.boxplot(x='Attrition', y='YearsSinceLastPromotion', data=df)
plt.title('Attrition by Years Since Last Promotion')
plt.xlabel('Attrition')
plt.ylabel('Years Since Last Promotion')

# 与现任经理共事年数与离职情况的关系
plt.subplot(2, 2, 4)
sns.boxplot(x='Attrition', y='YearsWithCurrManager', data=df)
plt.title('Attrition by Years with Current Manager')
plt.xlabel('Attrition')
plt.ylabel('Years with Current Manager')

plt.tight_layout()
plt.show()
```

![项目5-4-2-1.png](./pic/项目5-4-2-1.png)

**1.较短的在公司工作年数可能与较高的离职率相关联，这表明新员工可能更倾向于离职。  
**

**2.在当前职位上工作时间较短的员工可能更容易离职，这可能反映了对工作的不满或晋升机会的缺乏。  
**

**3.较长时间没有晋升的员工可能更倾向于离职（离职员工中位数略高于未离职员工），这可能是由于缺乏职业成长或晋升机会。  
**

**4.与现任经理共事时间较短的员工可能更容易离职。**

#### 6.使用不同的模型进行预测

**特征选择：年龄、出差、任职部门、教育等级、专业领域、工作环境满意度、性别、工作参与度、工作级别、工作满意度、婚姻状况、月收入、关系满意度、工作生活平衡评价、在公司工作年数、 担任现职年数、上次晋升后的年数、与现任经理共事年数。**

##### 6.1数据处理

```python
# 选择特征和目标变量
features = ['Age', 'BusinessTravel', 'Department', 'Education', 'EducationField',
            'EnvironmentSatisfaction', 'Gender', 'JobInvolvement', 'JobLevel',
            'JobSatisfaction', 'MaritalStatus', 'MonthlyIncome', 'RelationshipSatisfaction',
            'WorkLifeBalance', 'YearsAtCompany', 'YearsInCurrentRole',
            'YearsSinceLastPromotion', 'YearsWithCurrManager','Attrition']
new_df = df[features]
import warnings 
warnings.filterwarnings('ignore')
new_df['BusinessTravel'] = new_df['BusinessTravel'].map({
    'Non-Travel': 0,
    'Travel_Rarely': 1,
    'Travel_Frequently': 2
})

new_df['Gender'] = new_df['Gender'].map({
    'Female': 0,
    'Male': 1
})

new_df['MaritalStatus'] = new_df['MaritalStatus'].map({
    'Divorced': -1,
    'Single': 0,
    'Married': 1
})

new_df['Attrition'] = new_df['Attrition'].map({
    'Yes': 1,
    'No': 0
})
# 确定需要进行独热编码的分类变量
categorical_features = ['Department', 'EducationField']
# 重置行索引
new_df.reset_index(drop=True, inplace=True)
# 创建独热编码器
encoder = OneHotEncoder(sparse_output=False, handle_unknown='ignore')
# 应用独热编码
encoded_data = encoder.fit_transform(new_df[categorical_features])
# 将编码后的数据转换为DataFrame
encoded_df = pd.DataFrame(encoded_data, columns=encoder.get_feature_names_out(categorical_features))

# 将编码后的数据与原始数据合并
new_df = new_df.drop(categorical_features, axis=1)
new_df = pd.concat([new_df, encoded_df], axis=1)
x = new_df.drop('Attrition', axis=1)
y = new_df['Attrition']
#采用分层抽样来保证训练集和测试集中label与整体数据集的label分布相似
x_train, x_test, y_train, y_test = train_test_split(x, y, test_size=0.3, random_state=10, stratify=y) #3:7分
```

**考虑到Attrition不平衡，建立出来的模型可能不够理想，因此可以采取过采样或者欠采样使得样本平衡，在此案例中，欠采样会损失大量的样本数据，所以选择过采样的方法。**

```python
#分离少数类和多数类
x_minority = x_train[y_train == 1]
y_minority = y_train[y_train == 1]
x_majority = x_train[y_train == 0]
y_majority = y_train[y_train == 0]
x_minority_resampled = resample(x_minority, replace=True, n_samples=len(x_majority), random_state=15)
y_minority_resampled = resample(y_minority, replace=True, n_samples=len(y_majority), random_state=15)
new_x_train = pd.concat([x_majority, x_minority_resampled])
new_y_train = pd.concat([y_majority, y_minority_resampled])
```

**现在数据已经处理完毕，开始建立模型，我打算建立多个分类模型，并且建立评价指标评估模型的优劣。**

##### 6.2 svm

```python
from sklearn.svm import SVC
svm_clf = SVC(kernel='rbf')
# 训练模型
svm_clf.fit(new_x_train, new_y_train)
# 预测测试集
y_pred_svm = svm_clf.predict(x_test)
class_report_svm = classification_report(y_test, y_pred_svm)
print(class_report_svm)
```

![image_course_1657_user_3961_assignment_20194_1724304672604.png](./pic/image_course_1657_user_3961_assignment_20194_1724304672604.png)

**svm模型评分如下:**

**1.精确度: 对于类别0，精确度为0.87，对于类别1，精确度为0.24。**

**2.召回率: 对于类别0，召回率为0.70，对于类别1，召回率为0.48。**

**3.F1得分: 对于类别0，F1得分为0.78，对于类别1，F1得分为0.32。**

**4.准确率: 0.66**

##### 6.3 决策树

```python
from sklearn.tree import DecisionTreeClassifier
# 创建决策树模型
dtree_clf = DecisionTreeClassifier(random_state=15)

# 训练模型
dtree_clf.fit(new_x_train, new_y_train)

# 预测测试集
y_pred_dtree = dtree_clf.predict(x_test)
class_report_dtree = classification_report(y_test, y_pred_dtree)
print(class_report_dtree)
```

![image_course_1657_user_3961_assignment_20194_1724304711636.png](./pic/image_course_1657_user_3961_assignment_20194_1724304711636.png)

##### 6.4随机森林

```python
from sklearn.ensemble import RandomForestClassifier
rf_clf = RandomForestClassifier(random_state=15)
rf_clf.fit(new_x_train, new_y_train)
y_pred_rf = rf_clf.predict(x_test)
class_report_rf = classification_report(y_test, y_pred_rf)
print(class_report_rf)
```

![image_course_1657_user_3961_assignment_20194_1724304734773.png](./pic/image_course_1657_user_3961_assignment_20194_1724304734773.png)

##### 6.5AdaBoost

```python
from sklearn.ensemble import AdaBoostClassifier
from sklearn.tree import DecisionTreeClassifier
# 创建基础学习器（弱学习器）
base_estimator = DecisionTreeClassifier(max_depth=1)
# 创建AdaBoost模型
ada_clf = AdaBoostClassifier(estimator=base_estimator, n_estimators=50, random_state=42)
# 训练模型
ada_clf.fit(new_x_train, new_y_train)
# 预测测试集
y_pred_ada = ada_clf.predict(x_test)
class_report_ada = classification_report(y_test, y_pred_ada)
print(class_report_ada)
```

![image_course_1657_user_3961_assignment_20194_1724304756404.png](./pic/image_course_1657_user_3961_assignment_20194_1724304756404.png)

##### 6.6模型比较

| 模型 | 准确率 | 离职（类别1）的精确度 |
| --- | --- | --- |
| svm | 0.66 | 0.24 |
| 决策树 | 0.78 | 0.30 |
| 随机森林 | 0.84 | 0.52 |
| AdaBoost | 0.75 | 0.33 |

对比几个模型，可以看出随机森林在准确率和精确度上都比其它模型的表现更好，应选择使用基于随机森林的模型进行预测员工是否离职。

### 实验总结

**本项目主要针对离职率进行了探索，得出了以下结论：**

1.基于员工个人情况，离职情况主要集中在18-35岁的员工群体中，随着年龄增长，离职的人数有所下降，男性的离职率略高于女性的离职率，学历等级1-3级的离职率最高，人力资源专业、市场营销专业、技术专业离职率最高。

2.基于员工工作情况，经常出差的员工离职率高；人力资源部门和销售部门的离职率比研发部门高；离职的员工离职员工的通勤距离中位数略高于未离职员工；销售代表、人力资源和实验室技术员的离职率比较高，研究总监、 经理和制造总监的离职率较低；工作参与度越低的员工离职率越高；工作等级位于1级和3级的离职率比较高，离职员工的月收入中位数明显低于未离职员工，且未离职员工的月收入分布范围更广，尤其是在较高收入区间。

3.薪酬方面，离职员工加薪百分比中位数明显低于未离职员工；绩效评级只有3级和4级，离职率看起来与绩效评级的关系并不大；股票期权级别越高，越不容易离职；去年培训时间看起来与离职率的关系并不算大。

4.晋升方面，较短的在公司工作年数可能与较高的离职率相关联，这表明新员工可能更倾向于离职；在当前职位上工作时间较短的员工可能更容易离职，这可能反映了对工作的不满或晋升机会的缺乏；较长时间没有晋升的员工可能更倾向于离职（离职员工中位数略高于未离职员工），这可能是由于缺乏职业成长或晋升机会；与现任经理共事时间较短的员工可能更容易离职。

5.通过建立分类模型，预测哪些员工可能会离职。